<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

// ── POST /api/auth.php?action=login ───────────────────────────────────────
if ($method === 'POST' && $action === 'login') {
    $b = body();
    $username = trim($b['username'] ?? '');
    $password = $b['password'] ?? '';

    if (!$username || !$password) {
        resp(['error' => 'يرجى إدخال اسم المستخدم وكلمة المرور'], 400);
    }

    $pdo = db();
    $st = $pdo->prepare('SELECT * FROM users WHERE username = ?');
    $st->execute([$username]);
    $user = $st->fetch();

    if (!$user || !password_verify($password, $user['password'])) {
        resp(['error' => 'اسم المستخدم أو كلمة المرور غير صحيحة'], 401);
    }

    // Create session token
    $token = bin2hex(random_bytes(32));
    $expires = date('Y-m-d H:i:s', strtotime('+8 hours'));

    $pdo->prepare('DELETE FROM sessions WHERE user_id = ?')->execute([$user['id']]);
    $pdo->prepare('INSERT INTO sessions (user_id, token, expires_at) VALUES (?,?,?)')
        ->execute([$user['id'], $token, $expires]);

    $perms = json_decode($user['perms'] ?? '{}', true) ?: [];

    resp([
        'token' => $token,
        'user'  => [
            'id'       => $user['id'],
            'name'     => $user['name'],
            'username' => $user['username'],
            'avatar'   => $user['avatar'],
            'role'     => $user['role'],
            'perms'    => $perms,
        ]
    ]);
}

// ── POST /api/auth.php?action=logout ──────────────────────────────────────
if ($method === 'POST' && $action === 'logout') {
    $token = str_replace('Bearer ', '', $_SERVER['HTTP_AUTHORIZATION'] ?? '');
    if ($token) {
        db()->prepare('DELETE FROM sessions WHERE token = ?')->execute([$token]);
    }
    resp(['ok' => true]);
}

// ── GET /api/auth.php?action=me ───────────────────────────────────────────
if ($method === 'GET' && $action === 'me') {
    $session = authCheck();
    $pdo = db();
    $st = $pdo->prepare('SELECT id,name,username,avatar,role,perms FROM users WHERE id=?');
    $st->execute([$session['user_id']]);
    $user = $st->fetch();
    $user['perms'] = json_decode($user['perms'] ?? '{}', true) ?: [];
    resp($user);
}

// ── GET /api/auth.php?action=users (admin only) ───────────────────────────
if ($method === 'GET' && $action === 'users') {
    $session = authCheck();
    $pdo = db();
    $me = $pdo->prepare('SELECT role FROM users WHERE id=?');
    $me->execute([$session['user_id']]);
    if ($me->fetchColumn() !== 'admin') resp(['error' => 'Forbidden'], 403);

    $users = $pdo->query('SELECT id,name,username,avatar,role,perms,created_at FROM users ORDER BY role DESC, name')
                  ->fetchAll();
    foreach ($users as &$u) $u['perms'] = json_decode($u['perms'] ?? '{}', true) ?: [];
    resp($users);
}

// ── POST /api/auth.php?action=save_user ───────────────────────────────────
if ($method === 'POST' && $action === 'save_user') {
    $session = authCheck();
    $pdo = db();
    $meRole = $pdo->prepare('SELECT role FROM users WHERE id=?');
    $meRole->execute([$session['user_id']]);
    if ($meRole->fetchColumn() !== 'admin') resp(['error' => 'Forbidden'], 403);

    $b = body();
    $id       = $b['id'] ?? null;
    $name     = trim($b['name'] ?? '');
    $username = trim($b['username'] ?? '');
    $password = $b['password'] ?? '';
    $avatar   = $b['avatar'] ?? '👤';
    $role     = in_array($b['role']??'', ['admin','worker']) ? $b['role'] : 'worker';
    $perms    = json_encode($b['perms'] ?? new stdClass());

    if (!$name || !$username) resp(['error' => 'الاسم واسم المستخدم مطلوبان'], 400);

    if ($id) {
        // Update existing user
        if ($password) {
            $pdo->prepare('UPDATE users SET name=?,username=?,password=?,avatar=?,role=?,perms=? WHERE id=?')
                ->execute([$name, $username, password_hash($password, PASSWORD_DEFAULT), $avatar, $role, $perms, $id]);
        } else {
            $pdo->prepare('UPDATE users SET name=?,username=?,avatar=?,role=?,perms=? WHERE id=?')
                ->execute([$name, $username, $avatar, $role, $perms, $id]);
        }
        resp(['ok' => true, 'id' => $id]);
    } else {
        // New user
        if (!$password) resp(['error' => 'كلمة المرور مطلوبة للمستخدم الجديد'], 400);
        $newId = 'u' . uniqid();
        $pdo->prepare('INSERT INTO users (id,name,username,password,avatar,role,perms) VALUES (?,?,?,?,?,?,?)')
            ->execute([$newId, $name, $username, password_hash($password, PASSWORD_DEFAULT), $avatar, $role, $perms]);
        resp(['ok' => true, 'id' => $newId]);
    }
}

// ── DELETE /api/auth.php?action=del_user&id=xxx ───────────────────────────
if ($method === 'DELETE' && $action === 'del_user') {
    $session = authCheck();
    $pdo = db();
    $meData = $pdo->prepare('SELECT role FROM users WHERE id=?');
    $meData->execute([$session['user_id']]);
    if ($meData->fetchColumn() !== 'admin') resp(['error' => 'Forbidden'], 403);

    $id = $_GET['id'] ?? '';
    if ($id === $session['user_id']) resp(['error' => 'لا يمكن حذف حسابك الحالي'], 400);
    $pdo->prepare('DELETE FROM users WHERE id=?')->execute([$id]);
    resp(['ok' => true]);
}

// ── POST /api/auth.php?action=change_password ─────────────────────────────
if ($method === 'POST' && $action === 'change_password') {
    $session = authCheck();
    $b = body();
    $pdo = db();
    $user = $pdo->prepare('SELECT * FROM users WHERE id=?');
    $user->execute([$session['user_id']]);
    $user = $user->fetch();

    if (!password_verify($b['old_password'] ?? '', $user['password'])) {
        resp(['error' => 'كلمة المرور الحالية غير صحيحة'], 400);
    }
    $new = $b['new_password'] ?? '';
    if (strlen($new) < 4) resp(['error' => 'كلمة المرور يجب أن تكون 4 أحرف على الأقل'], 400);

    $pdo->prepare('UPDATE users SET password=? WHERE id=?')
        ->execute([password_hash($new, PASSWORD_DEFAULT), $user['id']]);
    resp(['ok' => true]);
}

resp(['error' => 'Invalid action'], 400);
