<?php
require_once 'config.php';
$session = authCheck();
$method  = $_SERVER['REQUEST_METHOD'];
$id      = $_GET['id'] ?? null;
$pdo     = db();

if ($method === 'GET') {
    if ($id) {
        $st = $pdo->prepare('SELECT * FROM clients WHERE id=?');
        $st->execute([$id]);
        resp($st->fetch() ?: []);
    }
    $q = '%' . ($_GET['q'] ?? '') . '%';
    $st = $pdo->prepare('SELECT * FROM clients WHERE name LIKE ? OR phone LIKE ? ORDER BY name LIMIT 100');
    $st->execute([$q, $q]);
    resp($st->fetchAll());
}

if ($method === 'POST') {
    $b = body();
    $cid = $b['id'] ?? ('c' . uniqid());
    $pdo->prepare('INSERT INTO clients (id,name,phone,address,sub,sub_val,wallet,wallet_bonus)
        VALUES (?,?,?,?,?,?,?,?)
        ON DUPLICATE KEY UPDATE name=VALUES(name),phone=VALUES(phone),address=VALUES(address),
        sub=VALUES(sub),sub_val=VALUES(sub_val),wallet=VALUES(wallet),wallet_bonus=VALUES(wallet_bonus)')
        ->execute([$cid, $b['name']??'', $b['phone']??'', $b['address']??'',
                   $b['sub']??'', $b['subVal']??0, $b['wallet']??0, $b['walletBonus']??0]);
    resp(['ok' => true, 'id' => $cid]);
}

if ($method === 'DELETE' && $id) {
    $pdo->prepare('DELETE FROM clients WHERE id=?')->execute([$id]);
    resp(['ok' => true]);
}

resp(['error' => 'Invalid request'], 400);
