<?php
define('DB_HOST', 'localhost');
define('DB_NAME', 'mahzari1_laundry');
define('DB_USER', 'mahzari1_laundry_user');
define('DB_PASS', 'A.L%nZ}!9*f*K@(u');
define('DB_CHARSET', 'utf8mb4');

// CORS - allow your domain
$allowed = $_SERVER['HTTP_ORIGIN'] ?? '';
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200); exit;
}

function db() {
    static $pdo = null;
    if (!$pdo) {
        try {
            $pdo = new PDO(
                'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset='.DB_CHARSET,
                DB_USER, DB_PASS,
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                 PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC]
            );
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => 'DB connection failed: ' . $e->getMessage()]);
            exit;
        }
    }
    return $pdo;
}

function resp($data, $code = 200) {
    http_response_code($code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

function body() {
    return json_decode(file_get_contents('php://input'), true) ?? [];
}

// Simple session token check
function authCheck() {
    $token = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    $token = str_replace('Bearer ', '', $token);
    if (!$token) { resp(['error' => 'Unauthorized'], 401); }
    $pdo = db();
    $st = $pdo->prepare('SELECT * FROM sessions WHERE token=? AND expires_at > NOW()');
    $st->execute([$token]);
    $session = $st->fetch();
    if (!$session) { resp(['error' => 'Session expired'], 401); }
    return $session;
}
