<?php
require_once 'config.php';
$session = authCheck();
$method  = $_SERVER['REQUEST_METHOD'];
$pdo     = db();
$type    = $_GET['type'] ?? '';
$id      = $_GET['id'] ?? null;

// ══════════════════════════════════════════
//  SERVICES
// ══════════════════════════════════════════
if ($type === 'services') {
    if ($method === 'GET') {
        $rows = $pdo->query('SELECT * FROM services ORDER BY sort_order, id')->fetchAll();
        resp($rows);
    }
    if ($method === 'POST') {
        $b = body();
        // Save multiple (full replace for group)
        if (isset($b['group'])) {
            $name = $b['group'];
            $pdo->prepare('DELETE FROM services WHERE name=?')->execute([$name]);
            foreach ($b['items'] as $i => $s) {
                $sid = $s['id'] ?? ('s'.uniqid());
                $pdo->prepare('INSERT INTO services (id,name,variant,ic,en,price,sort_order) VALUES (?,?,?,?,?,?,?)')
                    ->execute([$sid,$s['name']??$name,$s['variant']??'',$s['ic']??'🧺',$s['en']??'',$s['price']??0,$s['sort_order']??$i]);
            }
            resp(['ok'=>true]);
        }
        // Save single
        $sid = $b['id'] ?? ('s'.uniqid());
        $pdo->prepare('INSERT INTO services (id,name,variant,ic,en,price,sort_order) VALUES (?,?,?,?,?,?,?)
            ON DUPLICATE KEY UPDATE name=VALUES(name),variant=VALUES(variant),ic=VALUES(ic),
            en=VALUES(en),price=VALUES(price),sort_order=VALUES(sort_order)')
            ->execute([$sid,$b['name']??'',$b['variant']??'',$b['ic']??'🧺',$b['en']??'',$b['price']??0,$b['sort_order']??0]);
        resp(['ok'=>true,'id'=>$sid]);
    }
    if ($method === 'DELETE' && $id) {
        $pdo->prepare('DELETE FROM services WHERE id=?')->execute([$id]);
        resp(['ok'=>true]);
    }
    // PATCH — reorder (array of {id, sort_order})
    if ($method === 'PATCH') {
        $items = body();
        $st = $pdo->prepare('UPDATE services SET sort_order=? WHERE id=?');
        foreach ($items as $item) $st->execute([$item['sort_order'], $item['id']]);
        resp(['ok'=>true]);
    }
}

// ══════════════════════════════════════════
//  WORKERS
// ══════════════════════════════════════════
if ($type === 'workers') {
    if ($method === 'GET') { resp($pdo->query('SELECT * FROM workers ORDER BY name')->fetchAll()); }
    if ($method === 'POST') {
        $b = body();
        $wid = $b['id'] ?? ('w'.uniqid());
        $pdo->prepare('INSERT INTO workers (id,name,role,salary,bonus,deduction,commission,net)
            VALUES (?,?,?,?,?,?,?,?)
            ON DUPLICATE KEY UPDATE name=VALUES(name),role=VALUES(role),salary=VALUES(salary),
            bonus=VALUES(bonus),deduction=VALUES(deduction),commission=VALUES(commission),net=VALUES(net)')
            ->execute([$wid,$b['name']??'',$b['role']??'',$b['salary']??0,$b['bonus']??0,
                       $b['deduction']??0,$b['commission']??0,$b['net']??0]);
        resp(['ok'=>true,'id'=>$wid]);
    }
    if ($method === 'DELETE' && $id) {
        $pdo->prepare('DELETE FROM workers WHERE id=?')->execute([$id]);
        resp(['ok'=>true]);
    }
}

// ══════════════════════════════════════════
//  EXPENSES
// ══════════════════════════════════════════
if ($type === 'expenses') {
    if ($method === 'GET') {
        $from = $_GET['from'] ?? date('Y-m-01');
        $to   = $_GET['to']   ?? date('Y-m-d');
        $st   = $pdo->prepare('SELECT * FROM expenses WHERE date BETWEEN ? AND ? ORDER BY date DESC');
        $st->execute([$from, $to]);
        resp($st->fetchAll());
    }
    if ($method === 'POST') {
        $b = body();
        $eid = $b['id'] ?? ('e'.uniqid());
        $pdo->prepare('INSERT INTO expenses (id,type,description,amount,date)
            VALUES (?,?,?,?,?)
            ON DUPLICATE KEY UPDATE type=VALUES(type),description=VALUES(description),
            amount=VALUES(amount),date=VALUES(date)')
            ->execute([$eid,$b['type']??'',$b['desc']??'',$b['amount']??0,$b['date']??date('Y-m-d')]);
        resp(['ok'=>true,'id'=>$eid]);
    }
    if ($method === 'DELETE' && $id) {
        $pdo->prepare('DELETE FROM expenses WHERE id=?')->execute([$id]);
        resp(['ok'=>true]);
    }
}

// ══════════════════════════════════════════
//  SETTINGS (print config + sub plans)
// ══════════════════════════════════════════
if ($type === 'settings') {
    if ($method === 'GET') {
        $rows = $pdo->query('SELECT k,v FROM settings')->fetchAll();
        $out  = [];
        foreach ($rows as $r) $out[$r['k']] = $r['v'];
        // Also return sub plans
        $out['subPlans'] = $pdo->query('SELECT * FROM sub_plans')->fetchAll();
        resp($out);
    }
    if ($method === 'POST') {
        $b  = body();
        $st = $pdo->prepare('INSERT INTO settings (k,v) VALUES (?,?) ON DUPLICATE KEY UPDATE v=VALUES(v)');
        foreach ($b as $k => $v) {
            if ($k !== 'subPlans') $st->execute([$k, $v]);
        }
        resp(['ok'=>true]);
    }
}

// ══════════════════════════════════════════
//  SUB PLANS
// ══════════════════════════════════════════
if ($type === 'subplans') {
    if ($method === 'GET') { resp($pdo->query('SELECT * FROM sub_plans')->fetchAll()); }
    if ($method === 'POST') {
        $b = body();
        $pid = $b['id'] ?? ('p'.uniqid());
        $pdo->prepare('INSERT INTO sub_plans (id,name,pay,gets,color) VALUES (?,?,?,?,?)
            ON DUPLICATE KEY UPDATE name=VALUES(name),pay=VALUES(pay),gets=VALUES(gets),color=VALUES(color)')
            ->execute([$pid,$b['name']??'',$b['pay']??0,$b['get']??0,$b['color']??'#2a5298']);
        resp(['ok'=>true,'id'=>$pid]);
    }
    if ($method === 'DELETE' && $id) {
        $pdo->prepare('DELETE FROM sub_plans WHERE id=?')->execute([$id]);
        resp(['ok'=>true]);
    }
}

// ══════════════════════════════════════════
//  STATS (dashboard)
// ══════════════════════════════════════════
if ($type === 'stats') {
    $today = date('Y-m-d');
    $stats = [
        'totalRevenue'  => (float)$pdo->query('SELECT COALESCE(SUM(total),0) FROM orders')->fetchColumn(),
        'totalPaid'     => (float)$pdo->query('SELECT COALESCE(SUM(paid),0) FROM orders')->fetchColumn(),
        'totalExpenses' => (float)$pdo->query('SELECT COALESCE(SUM(amount),0) FROM expenses')->fetchColumn(),
        'totalWorkers'  => (float)$pdo->query('SELECT COALESCE(SUM(net),0) FROM workers')->fetchColumn(),
        'totalOrders'   => (int)$pdo->query('SELECT COUNT(*) FROM orders')->fetchColumn(),
        'totalClients'  => (int)$pdo->query('SELECT COUNT(*) FROM clients')->fetchColumn(),
        'todayOrders'   => (int)$pdo->prepare('SELECT COUNT(*) FROM orders WHERE date=?')->execute([$today]) ? 
                           $pdo->query("SELECT COUNT(*) FROM orders WHERE date='$today'")->fetchColumn() : 0,
        'readyOrders'   => (int)$pdo->query("SELECT COUNT(*) FROM orders WHERE status='جاهز'")->fetchColumn(),
        'delayed'       => $pdo->query("SELECT * FROM orders WHERE status!='مستلم' AND deliv_date < '$today'")->fetchAll(),
    ];
    // Monthly chart (last 6 months)
    $months = [];
    for ($i = 5; $i >= 0; $i--) {
        $m = date('Y-m', strtotime("-$i months"));
        $rev = (float)$pdo->query("SELECT COALESCE(SUM(paid),0) FROM orders WHERE DATE_FORMAT(date,'%Y-%m')='$m'")->fetchColumn();
        $exp = (float)$pdo->query("SELECT COALESCE(SUM(amount),0) FROM expenses WHERE DATE_FORMAT(date,'%Y-%m')='$m'")->fetchColumn();
        $months[] = ['month' => $m, 'rev' => $rev, 'exp' => $exp];
    }
    $stats['months'] = $months;
    resp($stats);
}

resp(['error' => 'Invalid type'], 400);
