<?php
require_once 'config.php';
$session = authCheck();
$method  = $_SERVER['REQUEST_METHOD'];
$id      = $_GET['id'] ?? null;
$pdo     = db();

function ordersWithItems($pdo, $where = '1', $params = []) {
    $st = $pdo->prepare("SELECT * FROM orders WHERE $where ORDER BY created_at DESC LIMIT 500");
    $st->execute($params);
    $orders = $st->fetchAll();
    foreach ($orders as &$o) {
        $items = $pdo->prepare('SELECT * FROM order_items WHERE order_id=?');
        $items->execute([$o['id']]);
        $o['svcs'] = array_map(function($i) {
            return ['id'=>$i['service_id'],'name'=>$i['service_name'],
                    'variant'=>$i['variant'],'price'=>(float)$i['price'],
                    'qty'=>(int)$i['qty'],'total'=>(float)$i['total']];
        }, $items->fetchAll());
        // camelCase for frontend
        $o['clientId']   = $o['client_id'];
        $o['clientName'] = $o['client_name'];
        $o['agentName']  = $o['agent_name'];
        $o['delivDate']  = $o['deliv_date'];
        $o['sub']        = (float)$o['sub_total'];
        $o['total']      = (float)$o['total'];
        $o['paid']       = (float)$o['paid'];
        $o['fee']        = (float)$o['fee'];
        $o['discount']   = (float)$o['discount'];
    }
    return $orders;
}

if ($method === 'GET') {
    if ($id) { resp(ordersWithItems($pdo, 'id=?', [$id])[0] ?? []); }
    $status = $_GET['status'] ?? '';
    $q      = $_GET['q'] ?? '';
    $where  = '1';
    $params = [];
    if ($status) { $where .= ' AND status=?'; $params[] = $status; }
    if ($q)      { $where .= ' AND (num LIKE ? OR client_name LIKE ?)';
                   $params[] = "%$q%"; $params[] = "%$q%"; }
    resp(ordersWithItems($pdo, $where, $params));
}

if ($method === 'POST') {
    $b   = body();
    $oid = $b['id'] ?? ('o' . uniqid());

    // Get next order number if new
    if (!isset($b['id'])) {
        $ctr = (int)$pdo->query("SELECT v FROM settings WHERE k='order_counter'")->fetchColumn();
        $ctr++;
        $num = 'INV-' . $ctr;
        $pdo->prepare("UPDATE settings SET v=? WHERE k='order_counter'")->execute([$ctr]);
    } else {
        $num = $b['num'];
    }

    $pdo->prepare('INSERT INTO orders
        (id,num,client_id,client_name,agent_name,date,deliv_date,status,payment,delivery,fee,discount,paid,sub_total,total,notes)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
        ON DUPLICATE KEY UPDATE
        client_id=VALUES(client_id),client_name=VALUES(client_name),agent_name=VALUES(agent_name),
        date=VALUES(date),deliv_date=VALUES(deliv_date),status=VALUES(status),payment=VALUES(payment),
        delivery=VALUES(delivery),fee=VALUES(fee),discount=VALUES(discount),paid=VALUES(paid),
        sub_total=VALUES(sub_total),total=VALUES(total),notes=VALUES(notes)')
        ->execute([$oid,$num,$b['clientId']??null,$b['clientName']??'',$b['agentName']??'',
                   $b['date']??date('Y-m-d'),$b['delivDate']??date('Y-m-d'),
                   $b['status']??'جاري',$b['payment']??'آجل',$b['delivery']??'استلام من المغسلة',
                   $b['fee']??0,$b['discount']??0,$b['paid']??0,$b['sub']??0,$b['total']??0,
                   $b['notes']??'']);

    // Re-insert items
    $pdo->prepare('DELETE FROM order_items WHERE order_id=?')->execute([$oid]);
    foreach (($b['svcs'] ?? []) as $s) {
        $pdo->prepare('INSERT INTO order_items (order_id,service_id,service_name,variant,price,qty,total)
            VALUES (?,?,?,?,?,?,?)')
            ->execute([$oid,$s['id']??'',$s['name']??'',$s['variant']??'',
                       $s['price']??0,$s['qty']??1,$s['total']??0]);
    }
    resp(['ok'=>true,'id'=>$oid,'num'=>$num]);
}

if ($method === 'DELETE' && $id) {
    $pdo->prepare('DELETE FROM orders WHERE id=?')->execute([$id]);
    resp(['ok'=>true]);
}

resp(['error'=>'Invalid request'], 400);
