<?php
// ══════════════════════════════════════════════
//  INSTALL — run once to create all tables
//  Then DELETE this file from your server!
// ══════════════════════════════════════════════
define('DB_HOST', 'localhost');
define('DB_NAME', 'mahzari1_laundry');
define('DB_USER', 'mahzari1_laundry_user');
define('DB_PASS', 'A.L%nZ}!9*f*K@(u');

try {
    $pdo = new PDO(
        'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4',
        DB_USER, DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
} catch (PDOException $e) {
    die('❌ Connection failed: ' . $e->getMessage());
}

$tables = [

'users' => "CREATE TABLE IF NOT EXISTS users (
    id VARCHAR(36) PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    avatar VARCHAR(10) DEFAULT '👤',
    role ENUM('admin','worker') DEFAULT 'worker',
    perms JSON,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'sessions' => "CREATE TABLE IF NOT EXISTS sessions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id VARCHAR(36) NOT NULL,
    token VARCHAR(64) UNIQUE NOT NULL,
    expires_at DATETIME NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'clients' => "CREATE TABLE IF NOT EXISTS clients (
    id VARCHAR(36) PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    phone VARCHAR(20),
    address TEXT,
    sub VARCHAR(50) DEFAULT '',
    sub_val DECIMAL(10,2) DEFAULT 0,
    wallet DECIMAL(10,2) DEFAULT 0,
    wallet_bonus DECIMAL(10,2) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'services' => "CREATE TABLE IF NOT EXISTS services (
    id VARCHAR(36) PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    variant VARCHAR(100) DEFAULT '',
    ic TEXT,
    en VARCHAR(100) DEFAULT '',
    price DECIMAL(10,2) DEFAULT 0,
    sort_order INT DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'orders' => "CREATE TABLE IF NOT EXISTS orders (
    id VARCHAR(36) PRIMARY KEY,
    num VARCHAR(20) UNIQUE NOT NULL,
    client_id VARCHAR(36),
    client_name VARCHAR(100),
    agent_name VARCHAR(100) DEFAULT '',
    date DATE,
    deliv_date DATE,
    status ENUM('جاري','جاهز','مستلم') DEFAULT 'جاري',
    payment ENUM('مدفوع','آجل','مدفوع جزئياً') DEFAULT 'آجل',
    delivery VARCHAR(100) DEFAULT 'استلام من المغسلة',
    fee DECIMAL(10,2) DEFAULT 0,
    discount DECIMAL(10,2) DEFAULT 0,
    paid DECIMAL(10,2) DEFAULT 0,
    sub_total DECIMAL(10,2) DEFAULT 0,
    total DECIMAL(10,2) DEFAULT 0,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (client_id) REFERENCES clients(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'order_items' => "CREATE TABLE IF NOT EXISTS order_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id VARCHAR(36) NOT NULL,
    service_id VARCHAR(36),
    service_name VARCHAR(100),
    variant VARCHAR(100) DEFAULT '',
    price DECIMAL(10,2),
    qty INT DEFAULT 1,
    total DECIMAL(10,2),
    FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'workers' => "CREATE TABLE IF NOT EXISTS workers (
    id VARCHAR(36) PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    role VARCHAR(100) DEFAULT '',
    salary DECIMAL(10,2) DEFAULT 0,
    bonus DECIMAL(10,2) DEFAULT 0,
    deduction DECIMAL(10,2) DEFAULT 0,
    commission DECIMAL(5,2) DEFAULT 0,
    net DECIMAL(10,2) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'expenses' => "CREATE TABLE IF NOT EXISTS expenses (
    id VARCHAR(36) PRIMARY KEY,
    type VARCHAR(50),
    description TEXT,
    amount DECIMAL(10,2),
    date DATE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'sub_plans' => "CREATE TABLE IF NOT EXISTS sub_plans (
    id VARCHAR(36) PRIMARY KEY,
    name VARCHAR(100),
    pay DECIMAL(10,2),
    gets DECIMAL(10,2),
    color VARCHAR(20) DEFAULT '#2a5298'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

'settings' => "CREATE TABLE IF NOT EXISTS settings (
    k VARCHAR(100) PRIMARY KEY,
    v TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

];

$created = [];
foreach ($tables as $name => $sql) {
    $pdo->exec($sql);
    $created[] = $name;
}

// ── Default admin user ──────────────────────────────────────────────────
$pdo->exec("INSERT IGNORE INTO users (id, name, username, password, avatar, role) VALUES
    ('u1', 'المدير', 'admin', '" . password_hash('Admin@1234', PASSWORD_DEFAULT) . "', '👑', 'admin')");

// ── Default sub plans ───────────────────────────────────────────────────
$pdo->exec("INSERT IGNORE INTO sub_plans (id,name,pay,gets,color) VALUES
    ('p1','باقة أساسية',100,130,'#2a5298'),
    ('p2','باقة متوسطة',200,270,'#27ae60'),
    ('p3','باقة مميزة',500,700,'#e8a020'),
    ('p4','باقة VIP',1000,1500,'#8b2fc9')");

// ── Default settings ────────────────────────────────────────────────────
$pdo->exec("INSERT IGNORE INTO settings (k,v) VALUES
    ('shop_name','مغاسل البطريق الذكية'),
    ('shop_sub','خدمات الغسيل والكي المتميزة'),
    ('shop_logo','🐧'),
    ('shop_phone',''),
    ('shop_address',''),
    ('show_client_name','1'),
    ('show_client_phone','1'),
    ('show_agent','1'),
    ('show_deliv_date','1'),
    ('show_barcode','1'),
    ('terms',''),
    ('order_counter','1000')");

?>
<!DOCTYPE html>
<html dir="rtl">
<head><meta charset="UTF-8"><title>تثبيت النظام</title>
<style>
  body{font-family:Tahoma,sans-serif;background:#f4f6fb;display:flex;align-items:center;justify-content:center;min-height:100vh;margin:0;}
  .box{background:#fff;border-radius:16px;padding:36px;max-width:500px;width:100%;box-shadow:0 8px 30px rgba(0,0,0,.1);}
  h2{color:#1a3a6b;margin-bottom:20px;}
  .ok{color:#27ae60;font-weight:700;}
  .warn{background:#fff3cd;border:1px solid #ffc107;border-radius:8px;padding:14px;margin-top:20px;color:#7a5500;}
  a{display:block;margin-top:16px;background:#1a3a6b;color:#fff;text-align:center;padding:12px;border-radius:8px;text-decoration:none;font-weight:700;}
</style></head>
<body>
<div class="box">
  <h2>🐧 تثبيت نظام المغسلة</h2>
  <?php foreach($created as $t): ?>
    <div class="ok">✅ جدول <strong><?= $t ?></strong> جاهز</div>
  <?php endforeach; ?>
  <div class="warn">
    ⚠️ <strong>مهم جداً:</strong> احذف ملف <code>install.php</code> من السيرفر فوراً بعد التثبيت!
    <br><br>
    بيانات الدخول الافتراضية:<br>
    👑 المدير: <strong>admin</strong> / <strong>Admin@1234</strong>
  </div>
  <a href="index.html">🚀 فتح النظام</a>
</div>
</body>
</html>
